/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *       tank_ev.cc
 *
 *       class definition of a Tank_event
 *       this Event makes a tank stop driving
 */

#include "tank_ev.h"
#include "server/globals.h"

Tank_event::Tank_event()
{
    freelist_index = SERVER_FREELIST_TANK_EVENT;
    actor_id = -1;
    what = -1;
}

void Tank_event::set(Stank *t, int _what)
{
    Event::set();

    actor_id = t->actor_id;
    what = _what;
}

void Tank_event::clear()
{
    actor_id = -1;
    what = -1;

    Event::clear();
}

void Tank_event::fire()
{
    // find the actor in the storage array
    Stank *t = (Stank *)storage->find(ACTOR_TANK, actor_id);
    
    if (!t)
    {
	return;       // not found at all? not valid
    }

    // t is still valid: go ahead
    if (what == DRIVE)
    {
	//  make it stop driving
	t->set_driving(0);
    }
    else if (what == RELOAD)
    {
	t->set_reloading(0);
    }
    else
    {
	warning("tank_event: invalid what %d", what);
    }
}

Tank_event *new_tank_event(Stank *t, int what)
{
    Tank_event *te;

    te = (Tank_event *)new_object(SERVER_FREELIST_TANK_EVENT);

    if (!te)
    {
	te = new Tank_event();
    }

    te->set(t, what);

    return te;
}
