/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *       selfdestruct_ev.cc
 *
 *       class definition of a Selfdestruct_event
 *       this Event makes an electron self-destruct
 *
 */

#include "selfdestruct_ev.h"
#include "server/globals.h"
#include "server/events/remove_ev.h"

Selfdestruct_event::Selfdestruct_event()
{
    freelist_index = SERVER_FREELIST_SELFDESTRUCT_EVENT;
    actor_id = -1;
    actor_type = -1;
}

void Selfdestruct_event::set(Electron *blowup)
{
    Event::set();
    
    actor_id = blowup->actor_id;
    actor_type = blowup->actor_type;
}

void Selfdestruct_event::clear()
{
    actor_type = -1;
    actor_id = -1;

    Event::clear();
}

void Selfdestruct_event::fire()
{
    Electron *blow;
    Sexplosion *se;
    
    // find the actor in the storage array
    blow = storage->find(actor_type, actor_id);

    if (!blow)
    {
	warning("Selfdestruct_event::fire : electron not found in storage");
	return;       // not found at all? not valid
    }

    warning("Selfdestruct_event: %s exploding", blow->type_name);
    
    // b is still valid: go ahead
    // remove the item from the game and possible do damage to everything
    // in the room.
    
    // make an explosion Object so the client can draw it
    se = new_actor<Sexplosion>(Electron::fid());
    storage->lowlevel_add(se);
    blow->get_atom()->add(se);

    warning("Selfdestruct_event: created clientside explosion at [%d,%d]",
	    se->gx(), se->gy());
    create_client_electron(se, &global_send_queue);

    // schedule the explosion Object to disappear in a few seconds
    evl->add_event(new_remove_event(se, 1), 200);
    damage_all_in_parent(blow, 0);

    // get rid of the grenade
    destroy_electron(blow);
}

Selfdestruct_event *new_selfdestruct_event(Electron *blow)
{
    Selfdestruct_event *ee;

    ee = (Selfdestruct_event *)new_object(SERVER_FREELIST_SELFDESTRUCT_EVENT);

    if (!ee)
    {
	ee = new Selfdestruct_event();
    }

    ee->set(blow);

    return ee;
}
