/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *          repair_ev.h
 *
 *          repair vehicle event:
 *          call the pulse() function of the repair vehicle
 */

#ifndef _REPAIR_EV_H_
#define _REPAIR_EV_H_

#include "server/eventlis.h"

class Rvfunc;

class Repair_event : public Event
{
public:
    Repair_event();
    void set(Rvfunc *_rv);
    void clear();
    void fire();
    void stop();
   
private:
    // a bit odd, but we cannot store a pointer to the repair_vehicle
    // since that doesn't know about the pulse() function
    // instead, store a pointer to the Rvfunc object embedded in
    // the derived class (Sambulance for example).
    Rvfunc *rv;       
    int running;
};

extern Repair_event *new_repair_event(Rvfunc *rv);

#endif
