/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *          repair_ev.cc
 *
 *          repair vehicle event
 */

#include "repair_ev.h"
#include "server/s_freelist.h"
#include "server/actors/rvfunc.h"

Repair_event::Repair_event()
{
    freelist_index = SERVER_FREELIST_REPAIR_EVENT;
    rv = 0;
    running = 0;
}

void Repair_event::set(Rvfunc *_rv)
{
    Event::set();

    rv = _rv;
    running = 1;
}

void Repair_event::clear()
{
    rv = 0;
    running = 0;

    Event::clear();
}

void Repair_event::stop()
{
    running = 0;
}

void Repair_event::fire()
{
    if (!running)
	return;

    rv->pulse();
}

Repair_event *new_repair_event(Rvfunc *_rv)
{
    Repair_event *re;

    re = (Repair_event *)new_object(SERVER_FREELIST_REPAIR_EVENT);

    if (!re)
    {
	re = new Repair_event();
    }

    re->set(_rv);

    return re;
}
