/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
g *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *       remove_ev.cc
 *
 *       class definition of a Remove_event
 *       this Event makes an electron disappear from the map
 */

#include "remove_ev.h"
#include "server/globals.h"

Remove_event::Remove_event()
{
    freelist_index = SERVER_FREELIST_REMOVE_EVENT;
    e = 0;
    actor_id = 0;
    x = 0;
    y = 0;
    same_pos = 1;
}

void Remove_event::set(Electron *new_e, int _same_pos)
{
    Event::set();

    e = new_e;
    actor_id = e->actor_id;
    actor_type = e->actor_type;
    e->get_pos(&x, &y);
    same_pos = _same_pos;
}

void Remove_event::clear()
{
    e = 0;
    actor_id = 0;
    actor_type = 0;
    x = 0;
    y = 0;
    same_pos = 1;

    Event::clear();
}

void Remove_event::fire()
{
    if (same_pos)
    {
	Atom *a = lattice->get(x, y);

	if (!a)
	{
	    warning("remove_event::fire : lattice changed??");
	    return;       // lattice changed? Event no longer valid
	}

	if (a->find(actor_type, actor_id) != e)
	{
	    warning("remove_event::fire : electron not found in atom");    
	    return;       // not found at the original position? not valid
	}
    }
    else
    {
	// find the actor in the storage array
	if (storage->find(actor_type, actor_id) != e)
	{
	    warning("remove_event::fire : electron not found in storage");
	    return;       // not found at all? not valid
	}
    }

    // e is still valid: remove it from the lattice
    destroy_electron(e);

    e = 0;
}

Remove_event *new_remove_event(Electron *e, int same_pos)
{
    Remove_event *re;

    re = (Remove_event *)new_object(SERVER_FREELIST_REMOVE_EVENT);

    if (!re)
    {
	re = new Remove_event();
    }

    re->set(e, same_pos);

    return re;
}
