/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *       reload_ev.cc
 *
 *       class definition of a Reload_event
 *       this Event makes a weapon stop reloading
 */

#include "reload_ev.h"
#include "server/globals.h"

Reload_event::Reload_event()
{
    freelist_index = SERVER_FREELIST_RELOAD_EVENT;
    actor_id = -1;
    actor_type = -1;
}

void Reload_event::set(Weapon *w)
{
    Event::set();

    actor_id = w->actor_id;
    actor_type = w->actor_type;
}

void Reload_event::clear()
{
    actor_id = -1;
    actor_type = -1;

    Event::clear();
}

void Reload_event::fire()
{
    // find the actor in the storage array
    Weapon *w = (Weapon *)storage->find(actor_type, actor_id);
    
    if (!w)
    {
	return;       // not found at all? not valid
    }

    w->set_reloading(0);
}

Reload_event *new_reload_event(Weapon *w)
{
    Reload_event *re;

    re = (Reload_event *)new_object(SERVER_FREELIST_RELOAD_EVENT);

    if (!re)
    {
	re = new Reload_event();
    }

    re->set(w);

    return re;
}
