/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *          pad_ev.cc
 *
 *          class implementation of a Pad_event
 *          reloads a pad after it's been activated
 */

#include "pad_ev.h"
#include "server/s_freelist.h"

Pad_event::Pad_event()
{
    freelist_index = SERVER_FREELIST_PAD_EVENT;
    p = 0;
    running = 0;    
}

void Pad_event::set(Pad *_p)
{
    Event::set();
    
    p = _p;
    running = 1;
}

void Pad_event::clear()
{
    p = 0;
    running = 0;

    Event::clear();
}

void Pad_event::fire()
{
    if (running)
    {
	p->set_reloading(0);
    }
}

void Pad_event::stop()
{
    p = 0;
    running = 0;
}

Pad_event *new_pad_event(Pad *p)
{
    Pad_event *pe;

    pe = (Pad_event *)new_object(SERVER_FREELIST_PAD_EVENT);

    if (!pe)
    {
	pe = new Pad_event;
    }

    pe->set(p);

    return pe;
}
