/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *       hover_ev.cc
 *
 *       class definition of a Hover_event
 *       this Event makes a weapon stop hovering
 */

#include "hover_ev.h"
#include "server/s_freelist.h"

Hover_event::Hover_event()
{
    freelist_index = SERVER_FREELIST_HOVER_EVENT;
    hov = 0;
    what = -1;
    running = 0;
}

void Hover_event::set(Shover *h, int w)
{
    Event::set();

    hov = h;
    running = 1;

    ASSERT (w == RELOAD || w == RECHARGE);
    what = w;
}

void Hover_event::clear()
{
    what = -1;
    hov = 0;
    running = 0;

    Event::clear();
}

void Hover_event::stop()
{
    running = 0;
}

void Hover_event::fire()
{
    // check if the hover still exists: is the running flag set?
    if (!running)
	return;

    ASSERT (what == RELOAD || what == RECHARGE);

    if (what == RELOAD)
	hov->set_reloading(0);
    else
	hov->recharge();
}

Hover_event *new_hover_event(Shover *h, int w)
{
    Hover_event *re;

    re = (Hover_event *)new_object(SERVER_FREELIST_HOVER_EVENT);

    if (!re)
    {
	re = new Hover_event();
    }

    re->set(h, w);

    return re;
}
