/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *          game_ev.cc
 *
 *          class implementation of a game event: start and stop games
 */

#include "game_ev.h"
#include "server/s_freelist.h"
#include "server/globals.h"

Game_event::Game_event()
{
    freelist_index = SERVER_FREELIST_GAME_EVENT;
    running = 0;
}

void Game_event::set(int _code, int _countdown)
{
    Event::set();

    running = 1;
    code = _code;
    countdown = _countdown;
}

void Game_event::clear()
{
    running = 0;
    code = 0;
    countdown = 0;

    Event::clear();
}

void Game_event::fire()
{
    Clock *cl;
    Game_event *tmpev;

//    warning("game_event::fire");
    
    if (running)
    {
	cl = game->get_clock();

	switch (code)
	{
	    case VOTE:
		game->start_new_game();
		break;
	    case START:
//		warning("game_event::list_refcount = %d", list_refcount);
		game->start();
		tmpev = new_game_event(Game_event::WARN, countdown);
		cl->set_event(tmpev);
		ASSERT(cl->get_event() == tmpev);
		evl->add_event(tmpev, cl->get_length() - countdown);
		break;
	    case WARN:
		game->warn();
		tmpev = new_game_event(Game_event::STOP, countdown);
		cl->set_event(tmpev);
		ASSERT(cl->get_event() == tmpev);
		evl->add_event(tmpev, countdown);
		break;
	    case STOP:
		game->stop();
		break;
	    default:
		ASSERT(0);
		break;
	}
    }

//    warning("game_event::fire : done");
}

void Game_event::stop()
{
    running = 0;
}

Game_event *new_game_event(int code, int countdown)
{
    Game_event *ge;

    ge = (Game_event *)new_object(SERVER_FREELIST_GAME_EVENT);

    if (!ge)
    {
	ge = new Game_event;
    }

    ge->set(code, countdown);

    return ge;
}
