/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *       explode_ev.cc
 *
 *       class definition of a Explode_event
 *       this Event makes a explode stop driving
 *
 *       (inconsistency above caused by global replace :)
 *
 *       what this event really does is make a bullet explode.
 */

#include "explode_ev.h"
#include "server/globals.h"
#include "remove_ev.h"

Explode_event::Explode_event()
{
    freelist_index = SERVER_FREELIST_EXPLODE_EVENT;
    actor_id = -1;
    actor_type = -1;
    killer_id = -1;
    killer_type = -1;
}

void Explode_event::set(Bullet *b, Electron *killer)
{
    Event::set();
    
    actor_id = b->actor_id;
    actor_type = b->actor_type;

    if (killer)
    {
	killer_id = killer->actor_id;
	killer_type = killer->actor_type;

	warning("setting explode Event: bullet %d %d killer %d %d",
		actor_type, actor_id, killer_type, killer_id);
    }
}

void Explode_event::clear()
{
    actor_type = -1;
    actor_id = -1;
    killer_id = -1;
    killer_type = -1;

    Event::clear();
}

void Explode_event::fire()
{
    // find the actor in the storage array
    Bullet *b = (Bullet *)storage->find(actor_type, actor_id);

    // killer may be NULL !!
    Electron *killer = storage->find(killer_type, killer_id);
    
    if (!b)
    {
	warning("Explode_event::fire : bullet not found in storage");
	return;       // not found at all? not valid
    }

    warning("Explode_event: %s exploding", b->type_name);
    
    // b is still valid: go ahead
    // explode should do damage to other electrons and remove
    // the bullet when desired
    b->explode(killer);
}

Explode_event *new_explode_event(Bullet *b, Electron *killer)
{
    Explode_event *ee;

    ee = (Explode_event *)new_object(SERVER_FREELIST_EXPLODE_EVENT);

    if (!ee)
    {
	ee = new Explode_event();
    }

    ee->set(b, killer);

    return ee;
}
