/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *       enter_ev.cc
 *
 *       class definition of an enter_event
 *       this event calls the trigger_enter function
 */

#include "server/globals.h"
#include "enter_ev.h"

Enter_event::Enter_event()
{
    freelist_index = SERVER_FREELIST_ENTER_EVENT;
    clear();
}

void Enter_event::set(Electron *who, Atom *where)
{
    Event::set();

    actor_id = who->actor_id;
    actor_type = who->actor_type;

    a = where;
}

void Enter_event::clear()
{
    actor_type = -1;
    actor_id = -1;
    a = 0;

    Event::clear();
}

void Enter_event::fire()
{
    // find the actor in the storage array
    Electron *w = (Electron *)storage->find(actor_type, actor_id);

    // atom must be set at this time
    ASSERT(a);
    
    if (!w)
    {
	// it's possible that the electron has already died in
	// the mean time: don't trigger anything
	return;
    }

    // call the triggers
    trigger_enter(w, a);
}

Enter_event *new_enter_event(Electron *who, Atom *where)
{
    Enter_event *ee;

    ee = (Enter_event *)new_object(SERVER_FREELIST_ENTER_EVENT);

    if (!ee)
    {
	ee = new Enter_event();
    }

    ee->set(who, where);

    return ee;
}
