/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *       door_ev.cc
 *
 *       class definition of an door_event
 *       event to change the state of a door
 */

#include "door_ev.h"
#include "common/actors/door.h"
#include "server/s_freelist.h"

Door_event::Door_event()
{
    freelist_index = SERVER_FREELIST_DOOR_EVENT;
    clear();
}

void Door_event::set(Atom *_where, int _state)
{
    Event::set();
    where = _where;
    state = _state;
}

void Door_event::clear()
{
    state = -1;
    where = 0;
    Event::clear();
}

void Door_event::fire()
{
    // find the door
    Electron *d = where->top_level_object;

    ASSERT(d);
    ASSERT(d->actor_type == ACTOR_DOOR);

    ((Door *)d)->set_state(state);
}

Door_event *new_door_event(Atom *where, int state)
{
    Door_event *de;

    de = (Door_event *)new_object(SERVER_FREELIST_DOOR_EVENT);

    if (!de)
    {
	de = new Door_event();
    }

    de->set(where, state);

    return de;
}
