/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *     brake_ev.cc
 *
 *     definition of a Brake_event
 */

#include "brake_ev.h"
#include "server/globals.h"

// brake Event: handle users network input until the first Packet_command
Brake_event::Brake_event(int user)
    : Event()
{
    freelist_index = SERVER_FREELIST_BRAKE_EVENT;
    u = user;
}

void Brake_event::fire()
{
    Packet *p;
    int t;    // time until next Event
    int type;
    
//    warning("BOEM!");
    
    // check if the user still exists
    if (!fb[u])
	return;

    // check if they're still in an active state
    if (users[u]->state != SHAKE_PLAYING)
	return;
    
    // read the users network queue until the first Packet_command
    while ((p = users[u]->read_queue_packet()))
    {
	// handle the packet
	users[u]->process_packet(p);
	type = p->get_type();
	delete_object(p);

	if (type == TYPE_COMMAND)
	{
	    // only brake if the player actually spent time
	    // if they ran into a wall 100 times, they don't want
	    // to wait 100 server frames

	    if (users[u]->time_spent() > 0)
	    {
//		warning("time_spent: %d", users[u]->time_spent());
		break;
	    }
	}
    }

    t = users[u]->time_spent();
    users[u]->set_time_spent(0);     // reset the users spent time

    // the minimum spent time is 10 (the next server frame)
    // otherwise we may end up in an endless loop in Eventlist.tick()
    if (t <= 0)
	t = 10;

    // schedule a new Event
    evl->add_event(new_brake_event(u), t);
}

void Brake_event::set(int n_user)
{
    Event::set();
    
    u = n_user;
}

void Brake_event::clear()
{
    Event::clear();
}

Brake_event *new_brake_event(int connection)
{
    Brake_event *be;

    be = (Brake_event *)new_object(SERVER_FREELIST_BRAKE_EVENT);

    if (!be)
    {
	be = new Brake_event();
    }

    be->set(connection);

    return be;
}
