/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *         eventlis.h
 *
 *         class declaration of an Eventlist
 */

 
#ifndef _eventlist_h_
#define _eventlist_h_

#include "common/object.h"
#include "common/list.h"

// base Event class (virtual) to derive new events from

class Event : public Object
{
public:
    Event();
    virtual ~Event();

    virtual void set();
    virtual void clear();
    
    unsigned long get_when() const;        // when does the Event go off
    void set_when(unsigned long new_when); // set a new time to fire
    
    virtual void fire() = 0;             // fire off the Event

    char deleted;                        // flag to mark as deleted

private:                                 // derived classes do not get access
    unsigned long when;
};

class Eventlist : public List
{
public:
    Eventlist();
    virtual ~Eventlist();

                                       // add the Event, sort by time
    void add_event(Event *new_event, long time_to_fire); 
    void tick(int time_inc);           // one time step ahead, process events
    
private:
    unsigned long time;                  // what time is it now
};

#endif
