/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *        eventlis.cc
 *
 *        class definition of an Eventlist
 */

 
#include "eventlis.h"
#include "common/freelist.h"
#include "common/utils.h"

Event::Event()
{
    // do not add set and clear here. they're called through
    // object and/or the derived class.
}

Event::~Event()
{
}

void Event::set()
{
    when = 0;
    deleted = 0;
}

void Event::clear()
{
    deleted = 0;
    when = 0;
    
    Object::clear();
}

unsigned long Event::get_when() const
{
    return when;
}

void Event::set_when(unsigned long new_when)
{
    when = new_when;
}

Eventlist::Eventlist()
    : List()
{
    time = 0;
}

Eventlist::~Eventlist()
{
    clear();    // remove all elements from the List
}

void Eventlist::add_event(Event *new_event, long time_to_fire)
{
    // find the element before which the Event has to be inserted
    Event *tmp;

    new_event->set_when(time_to_fire + time);

    for (reset(); (tmp = (Event *)get()); next())
    {
	if (tmp->get_when() > new_event->get_when())
	    break;
    }

    // if an Event was found, insert before it.
    // if we reached the tail, insert at the tail.
    insert(new_event);
}

int delete_marked_events(Object *_ev)
{
    Event *ev = (Event *)_ev;

    if (ev->deleted)
    {
	return List::FILTER_DELETE_OBJECT;
    }
    else
    {
	return List::FILTER_LEAVE;
    }
}

static unsigned int the_eventlist_clock;

int select_old_events(Object *_ev)
{
    Event *ev = (Event *)_ev;

    if (ev->get_when() <= the_eventlist_clock)
    {
	return List::FILTER_COPY;
    }
    else
    {
	return List::FILTER_LEAVE;
    }
}

void Eventlist::tick(int time_inc)
{
    Event *tmp;
    List scratch_list;
    
    // pay attention here, this may cause trouble if
    // somehow things get added to the front of the event list:
    // traversal will get mixed up. Mark events for deletion instead,
    // and delete them afterwards. This also goes wrong if add_event
    // is called: it messes up the current pointer of evl. Therefore
    // use a temporary traversal list.

    // set the time
    the_eventlist_clock = time;
    
    // create temporary traversal list
    filter(select_old_events, &scratch_list);
    
    // traverse list
    for (scratch_list.reset();
	 (tmp = (Event *)scratch_list.get());
	 scratch_list.next())
    {
	if (!tmp->deleted)
	{
	    tmp->fire();           // fire off the Event
	    tmp->deleted = 1;      // mark for deletion
	}
	else
	{
	    // bug: event already deleted. should never occur.
	    ASSERT(0);
	}
    }

    // clear temporary list
    scratch_list.clear();
    
    // filter marked events and delete them
    filter(delete_marked_events, 0);

    // next time step
    time += time_inc;
}
