/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *       damage.cc
 *
 *       utility functions for damaging things. :>
 */

#include "globals.h"

/* functions to tell the world about things getting damaged */

void write_h(Electron *e)
{
    e->write_health(packet_to_queue, &global_send_queue);
}

// note about functions damaging everything in an electron:
// the container receives damage too! this is the most logical case
// in many situations: for example an exploding grenade.
// if the grenade explodes in a room it doesn't seem to make sense to
// damage the room, but if it explodes in a tank it makes sense to
// damage the tank. And rooms don't take damage, so it doesn't really
// matter. Hint: it is a BAD idea to pick up a grenade that is
// about to explode.
// it all happens in damage_all_in_electron (at the end)

// do damage to everything in the room (top_level_object)
int damage_all_in_room(Atom *a, Electron *bully, Electron *killer)
{
    if (!a->top_level_object)
    {
	warning("damage_all_in_room : no top level Object??");
	return 0;
    }

    return damage_all_in_electron(a->top_level_object, bully, killer);
}

int damage_all_in_parent(Electron *bully, Electron *killer)
{
    // if we don't specify where the damage is to take place,
    // it defaults to bully's parent

    if (!bully->parent)
    {
	warning("damage_all_in_parent : no parent ??");
	return 0;
    }
    
    return damage_all_in_electron(bully->parent, bully, killer);
}

int damage_all_in_electron(Electron *where, Electron *bully, Electron *killer)
{
    List *l;
    List scratch_list;
    Electron *e;
    
    l = where->inv();

    if (!l)
    {
	warning("damage_all_in_electron : 'where' has no inventory ?!?");
	return 0;
    }
    
    l->clearcopy(&scratch_list);
    for (scratch_list.reset();
	 (e = (Electron *)scratch_list.get());
	 scratch_list.next())
    {
	// don't damage bully: we don't want it to die halfway
	if (e != bully)
	{
	    bully->do_damage(e, killer);

	    if (e->dead)
		continue;

	    write_h(e);
	}
    }

    // damage the parent
    bully->do_damage(where, killer);
    if (!where->dead)
	write_h(where);
    
    return 1;
}
