/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *           create.h
 *
 *           utility functions to create electrons
 *           (or to create them at the client side)
 *
 */


#ifndef _CREATE_H_
#define _CREATE_H_

#include "s_common.h"

extern void create_client_electron(Electron *e, Plug *p);
extern void create_client_electron(Electron *e, List *q);
extern void destroy_electron(Electron *e);
extern void die_electron(Electron *e, Electron *killer);
extern void die_player(Splayer *pl, Electron *killer);

// toss a dead electron in the garbage list
extern void garbage_electron(Electron *e);
// clean the garbage list (delete_object): return how many were in it
extern int  empty_garbage();

#endif
