/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *          sweaponmachine.h
 */


#ifndef _SWEAPONMACHINE_H_
#define _SWEAPONMACHINE_H_


#include "common/actors/weaponmachine.h"
#include "common/packet.h"
#include "server/actors/splayer.h"


class Sweaponmachine : public Weaponmachine
{
public:
    
    void set(int actor_id = 0);
    void clear();

    int select_weapon(Splayer *pl, Packet_command *pc);
    int load_weapons();
};

struct load_weapon_struct
{
    int weapon_type;
    int actor_type;
    int (*load_weapon)(Splayer *pl);
};

enum weapon_types
{
    WEAPON_NONE       = 0,
    WEAPON_LIGHTCYCLE,
    WEAPON_TANK,
    WEAPON_LAUNCHER,
    WEAPON_HOVER,
    WEAPON_LAST
};

extern load_weapon_struct weapon_table[WEAPON_LAST];

// these functions defined in sweaponmachine.cc
extern int load_none        (Splayer *pl);
extern int load_lightcycle  (Splayer *pl);
extern int load_tank        (Splayer *pl);
extern int load_launcher    (Splayer *pl);
extern int load_hover       (Splayer *pl);
extern int load_held_weapon (Splayer *pl, Electron *e);
extern int load_vehicle     (Splayer *pl, Vehicle *e);

#endif
