/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *       stank.h
 *
 *       server version of the Tank
 */

#ifndef _STANK_H_
#define _STANK_H_

#include "common/actors/tank.h"
#include "common/atom.h"

class Stank : public Tank
{
public:
    void set(int actor_id = 0);   // public constructor /destructor
    void clear();

    void die(Electron *pl);
    
    int move_dir(int dir, Electron *pl);
    int get_driving();
    void set_driving(int yesno);
    int get_reloading();
    void set_reloading(int yesno);
    
    int fire_to(Atom *a, Electron *pl);
    int fire_at(Electron *bokje, Electron *pl);
    int turn(int dir);
    void door(int d) const;            // called when someone tries to enter
                                       // through a closed door

    void set_int_var(int var_id, int val);
    
protected:
    int driving;
    int drive_time;
    int reloading;
    int reload_time;
    int flight_time;
    float fire_range;
    float target_range;
};

#endif
