/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *          srepair_pad.cc
 */


#include "srepair_pad.h"
#include "server/globals.h"

void Srepair_pad::set(int _actor_id)
{
    Repair_pad::set(_actor_id);
    Spad::set();
}

void Srepair_pad::clear()
{
    Repair_pad::clear();
    Spad::clear();
}

int Srepair_pad::trigger(Electron *what)
{
    if (int_vars[RELOADING])
    {
	return 0;
    }
    
    // only repair vehicles
    if (!what->is_group(GROUP_VEHICLE))
	return 0;

    if (what->get_h() < 1000)
    {
	// it's broken
	warning("repair_pad : repairing %s (%d)",
		what->type_name, what->actor_id);

	repair_vehicle(what);

	// add a reload event
	// this also sets our state to reloading and handles
	// eventlist and client communication
	reload();
	set_int_var(RELOADING, 1);

	return 1;
    }

    return 0;
}

void Srepair_pad::repair_vehicle(Electron *v)
{
    // we have a vehicle: repair it
    v->set_h(1000);
    write_h(v);
    
    // if it's a broken lightcycle, fix it
    if (v->actor_type == ACTOR_LIGHTCYCLE)
    {
	((Lightcycle *)v)->set_int_var(Lightcycle::BROKEN, 0);
    }
}

void Srepair_pad::set_int_var(int var_id, int val)
{
    TRACE("Srepair_pad::set_int_var");

    Repair_pad::set_int_var(var_id, val);

    // let the world know what happened
    write_vars(packet_to_queue, &global_send_queue);
}
