/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *        sred_ball.cc
 *
 *        server version of Red_ball
 *        a red ball is a bouncing ball (explode multiple times)
 */

#include "sred_ball.h"
#include "sexplosion.h"
#include "server/globals.h"
#include "server/events.h"

void Sred_ball::set(int _actor_id)
{
    Red_ball::set(_actor_id);
    exploded = 0;
    max_explosions = 3;
}

void Sred_ball::clear()
{
    Red_ball::clear();
    exploded = 0;
}

int Sred_ball::explode(Electron *killer)
{
    Sexplosion *se;
    int ret;
    
    warning("Sred_ball exploding: %d damage", get_d());

    // make an explosion Object so the client can draw it
    se = new_actor<Sexplosion>(Electron::fid());
    storage->lowlevel_add(se);
    get_atom()->add(se);

    warning("explode_event: created clientside explosion at [%d,%d]",
	    se->gx(), se->gy());
    create_client_electron(se, &global_send_queue);

    // schedule the explosion Object to disappear in a short while
    evl->add_event(new_remove_event(se, 1), 50);

    // do damage
    ret = damage_all_in_parent(this, killer);

    // check if we have to disappear
    exploded++;
    if (exploded < max_explosions)
    {
	// schedule a new explosion in a few seconds
	evl->add_event(new_explode_event(this, killer), 200);
    }
    else
    {
	// reset explosion counter for future use
	exploded = 0;
    }

    return ret;
}
