/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *       splayer.h
 *
 *       server version of Player
 */

#ifndef _SPLAYER_H_
#define _SPLAYER_H_

#include "common/actors/player.h"
#include "server/game/team.h"

class User;

class Splayer : public Player
{
public:
    // don't create a real constructor and destructor
    // just set and clear, which call Player::set and Player::clear
    // this should ensure that all other data in Player is properly
    // initiated and destroyed. The User *u only needs to be set
    // and cleared, there it may not be deleted.
    void set(int actor_id = 0);   // public constructor /destructor
    void clear();
    
    void die(Electron *pl);

    void set_user(User *u);
    User *get_user() const;

    void set_team(Team *t);
    Team *get_team() const;

    int get_running() const;
    void set_running(int r);
    
    // functions to handle the time spent with doing commands
    int time_spent() const;        // how much time did we spend
    void set_time_spent(int ts);   // used to reset spent
    void spend_time(int how_much); // spend an amount of time

    // damage functions to notify the game of what's happening
    void rec_damage(int hoeveel, Electron *killer);
    
protected:
    User *u;
    Team *t;

    int running;                   // are we alive in the game
};

#endif

 
