/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *        splayer.cc
 *
 *        server version of Player
 */

#include "splayer.h"
#include "server/user.h"
#include "server/create.h"
#include "server/globals.h"

void Splayer::die(Electron *killer)
{
    /*
    if (killer)
    {
	warning("player %s was killed by %s %d.",
		get_string_var(Player::NAME),
		killer->type_name,
		killer->actor_id
	       );
    }
    else
    {
	warning("player %s died.",
		get_string_var(Player::NAME)
	       );
    }
    */
    
    if (u)
    {
	// call the die_player function of the current game instead
	// die_player(this, killer);
	// if it returns 0, do not continue with the dying
	ASSERT(game);
	if (!game->die_player(this, killer))
	    return;

	// let the game check if it should stop
	game->check();
    	
	// this is a 'real' player with a user connected.
	// let the user know they died, and send a hangup
	u->send_queue_packet(new_packet_info_num(ACTOR_SYSTEM,
						 SYS_MESSAGE,
						 System::STC_YER_DEAD,
						 0));
    }
    else
    {
	die_electron(this, killer);
    }
}

// public constructor /destructor
// these need to call Player::clear and Player::set !!!!
void Splayer::set(int actor_id = 0)
{
    Player::set(actor_id);
    u = NULL;               // u should be set with set_user();
    t = NULL;
    running = 0;
}

void Splayer::clear()
{
    // remove the player from it's team and notify the game
    if (t)
    {
	t->pop(this);
	t = NULL;

	// let the game check if it should stop
	ASSERT(game);
	game->check();
    }

    running = 0;
    
    Player::clear();
    u = NULL;
}

void Splayer::set_team(Team *nt)
{
    t = nt;
}

Team * Splayer::get_team() const
{
    return t;
}

// how much time did we spend
int Splayer::time_spent() const
{
    if (!u)
    {
	warning("Splayer::time_spent() : NULL user!");
	return 1;
    }

    return u->time_spent();
}

// used to reset spent
void Splayer::set_time_spent(int ts)
{
    if (!u)
    {
	warning("Splayer::set_time_spent() : NULL user!");
	return;
    }

    u->set_time_spent(ts);
}

// spend an amount of time
void Splayer::spend_time(int how_much)
{
    if (!u)
    {
	warning("Splayer::spend_time() : NULL user!");
	return;
    }

    u->spend_time(how_much);
}

void Splayer::set_user(User *_u)
{
    u = _u;
}

User *Splayer::get_user() const
{
    return u;
}

void Splayer::rec_damage(int hoeveel, Electron *killer)
{
    // players without a user don't count as players.
    if (u)
    {
	if (!game)
	{
	    warning("Splayer::rec_damage: no game created yet!");
	}
	else
	{
	    // notify the game of what's happening
	    if (killer && killer->actor_type != ACTOR_PLAYER)
	    {
		// call the damage function of the game
		// if it returns 0, do not continue with the damage dealing!
		if (!game->damage_player(this, 0))
		    return;
	    }
	    else
	    {
		if (!game->damage_player(this, (Splayer *)killer))
		    return;
	    }
	}
    }
    
    // call base class function
    Electron::rec_damage(hoeveel, killer);
}

int Splayer::get_running() const
{
    return running;
}

void Splayer::set_running(int r)
{
    running = r;
}
