/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *          spad.h
 *
 *          server baseclass for pads: Spad
 *          virtual derivation of Pad, all common pads
 *          should also derive virtually from Pad
 */

#ifndef _SPAD_H_
#define _SPAD_H_

#include "common/actors/pad.h"
#include "server/events/pad_ev.h"

class Spad : virtual public Pad
{
public:
    Spad();
    
    void set();
    void clear();

    void set_event(Pad_event *_pe);
    void clear_event();

    void reload();
    
    virtual int trigger_enter_electron(Electron *who, Electron *what);
    virtual int trigger_enter_atom(Electron *who);
    virtual int trigger(Electron *who) = 0;
    
protected:
    Pad_event *pe;
    int reload_time;
};

#endif
