/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *          spad.cc
 *
 *          class implementation of Spad
 *          server baseclass for Pads
 */

#include "spad.h"
#include "server/globals.h"

Spad::Spad()
{
    reload_time = 1000;   // default reload 10 seconds
    pe = 0;
}

void Spad::set()
{
    clear_event();
}

void Spad::clear()
{
    clear_event();
}

void Spad::set_event(Pad_event *_pe)
{
    if (pe)
    {
	pe->stop();
    }

    pe = _pe;
} 

void Spad::reload()
{
    // create a new event
    Pad_event *_pe = new_pad_event(this);
    set_event(_pe);
    evl->add_event(pe, reload_time);
}

void Spad::clear_event()
{
    if (pe)
    {
	pe->stop();
	pe = 0;
    }
}

int Spad::trigger_enter_atom(Electron *who)
{
    if (who->parent == parent)
	return trigger(who);
    else
	return 0;
}

int Spad::trigger_enter_electron(Electron *who, Electron *what)
{
    if (what == parent)
	return trigger(who);
    else
	return 0;
}
