/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *         new_act.cc
 *
 *         contains get_electron_from_type
 *         adapt for each new actor_type
 */

#include "common/act_type.h"
#include "server/actors/sactors.h"

// given an actor type and an actor id, create the appropriate electron
Electron *get_electron_from_type(int type, int id)
{
    Electron *e = 0;
    
    switch(type)
    {
        case ACTOR_SYSTEM:
            e = new_actor<Ssystem>(0);   // system constructor doesn't get an actor_id
            break;
        case ACTOR_SIMPLE_ROOM:
            e = new_actor<Ssimple_room>(id);
            break;
        case ACTOR_PLAYER:
            e = new_actor<Splayer>(id);
            break;
        case ACTOR_LIGHTCYCLE:
            e = new_actor<Slightcycle>(id);
            break;
        case ACTOR_KEY:
            e = new_actor<Skey>(id);
            break;
        case ACTOR_CYCLEWALL:
            e = new_actor<Scyclewall>(id);
            break;
        case ACTOR_TANK:
            e = new_actor<Stank>(id);
            break;
        case ACTOR_GRENADE:
            e = new_actor<Sgrenade>(id);
            break;
        case ACTOR_EXPLOSION:
            e = new_actor<Sexplosion>(id);
            break;
        case ACTOR_LAUNCHER:
            e = new_actor<Slauncher>(id);
            break;
        case ACTOR_BLUE_BALL:
            e = new_actor<Sblue_ball>(id);
            break;
        case ACTOR_YELLOW_BALL:
            e = new_actor<Syellow_ball>(id);
            break;
        case ACTOR_RED_BALL:
            e = new_actor<Sred_ball>(id);
            break;
	case ACTOR_HOVER:
	    e = new_actor<Shover>(id);
	    break;
	case ACTOR_LASERBEAM:
	    e = new_actor<Slaserbeam>(id);
	    break;
	case ACTOR_MINE:
	    e = new_actor<Smine>(id);
	    break;
	case ACTOR_DOOR:
	    e = new_actor<Sdoor>(id);
	    break;
        case ACTOR_WATER:
            e = new_actor<Swater>(id);
            break;
        case ACTOR_DOORKEY:
            e = new_actor<Sdoorkey>(id);
            break;
        case ACTOR_AMBULANCE:
            e = new_actor<Sambulance>(id);
            break;
        case ACTOR_MEDICAL_PAD:
            e = new_actor<Smedical_pad>(id);
            break;
        case ACTOR_AMMO_PAD:
            e = new_actor<Sammo_pad>(id);
            break;
        case ACTOR_REPAIR_PAD:
            e = new_actor<Srepair_pad>(id);
            break;
        case ACTOR_FIETSENMAKER:
            e = new_actor<Sfietsenmaker>(id);
            break;
        case ACTOR_WEAPONSMITH:
            e = new_actor<Sweaponsmith>(id);
            break;
        case ACTOR_VOTE_ROOM:
            e = new_actor<Svote_room>(id);
            break;
        case ACTOR_VOTEMACHINE:
            e = new_actor<Svotemachine>(id);
            break;
        case ACTOR_WEAPONMACHINE:
            e = new_actor<Sweaponmachine>(id);
            break;
        case ACTOR_SAFE_ROOM:
            e = new_actor<Ssafe_room>(id);
            break;
// END_OF_CASE
        default:
            warning("Illegal or unknown actor type %d", type);
            break;
    }
    return e;
}
