/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *        smine.cc
 *
 *        server version of Mine
 */

#include "smine.h"
#include "sexplosion.h"
#include "server/globals.h"

void Smine::set(int _actor_id)
{
    Mine::set(_actor_id);
    set_owner(0);
}

void Smine::clear()
{
    Mine::clear();
    set_owner(0);
}

void Smine::set_owner(Electron *owner)
{
    if (!owner)
    {
	owner_id = -1;
	owner_type = -1;
    }
    else
    {
	owner_type = owner->actor_type;
	owner_id = owner->actor_id;
    }
}

Electron *Smine::find_owner()
{
    Electron *ret;

    if (owner_id == -1 && owner_type == -1)
	return 0;
    
    ret = storage->find(owner_type, owner_id);
    return ret;
}

int Smine::explode(Electron *bokje)
{
    Sexplosion *se;
    
    warning("Smine exploding: %d damage", get_d());

    // make an explosion Object so the client can draw it
    se = new_actor<Sexplosion>(Electron::fid());
    storage->lowlevel_add(se);
    get_atom()->add(se);

    warning("Smine::explode : creating clientside explosion at [%d,%d]",
	    se->gx(), se->gy());
    create_client_electron(se, &global_send_queue);

    // schedule the explosion Object to disappear in a few seconds
    evl->add_event(new_remove_event(se, 1), 100);

    // do damage, and report to the client if the target still lives
    // pass the result of find_owner to do_damage
    // this may be NULL, but that's allowed for do_damage
    do_damage(bokje, find_owner());
    if (!bokje->dead)
	write_h(bokje);
    
    // get rid of the mine
    destroy_electron(this);
    
    return 1;
}

// overload the trigger function to explode on entry
int Smine::trigger_enter_atom(Electron *bokje)
{
    // don't explode on hovers
    if (bokje->actor_type == ACTOR_HOVER)
	return 0;
    
    warning("Smine::trigger_enter_room : boom!");
    return explode(bokje);
}
