/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *          smedical_pad.cc
 */


#include "smedical_pad.h"
#include "server/globals.h"


void Smedical_pad::set(int _actor_id)
{
    Medical_pad::set(_actor_id);
    Spad::set();
    
    heal_amount = 100;         // 10% of max health
}

void Smedical_pad::clear()
{
    Medical_pad::clear();
    Spad::clear();
}

int Smedical_pad::trigger(Electron *who)
{
    if (int_vars[RELOADING])
    {
	return 0;
    }
    
    if (who->actor_type == ACTOR_PLAYER)
    {
	if (who->get_h() < 1000)
	{
	    warning("medical pad : healing player %d", who->actor_id);
	    
	    // we have a wounded player
	    heal_electron(who);

	    // set a reload event
	    reload();
	    set_int_var(RELOADING, 1);

	    return 1;
	}
    }

    return 0;
}

void Smedical_pad::heal_electron(Electron *pl)
{
    int h = min(pl->get_h() + heal_amount, 1000);
    pl->set_h(h);

    // let the world know what happened
    write_h(pl);
}

void Smedical_pad::set_int_var(int var_id, int val)
{
    Medical_pad::set_int_var(var_id, val);

    write_vars(packet_to_queue, &global_send_queue);
}
