/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *        slightcycle.cc
 *
 *        server version of Lightcycle
 */

#include "slightcycle.h"
#include "scyclewall.h"
#include "server/globals.h"
#include "server/usercomm.h"
#include "server/message.h"

int Slightcycle::move_to(int x, int y, Electron *pl)
{
    warning("Slightcycle::move_to : Slightcycle's cannot move to");
    
    return 0;
}

int Slightcycle::move_step(int dir, Electron *pl)
{
    int
	tx,
	ty,
	ox,
	oy;

    int
	ret;

    // store the room we came from
    ox = tx = gx();
    oy = ty = gy();
    
    switch (dir)
    {
	case DIR_N:
	    ty--;
	    break;
	case DIR_E:
	    tx++;
	    break;
	case DIR_S:
	    ty++;
	    break;
	case DIR_W:
	    tx--;
	    break;
    }

    // we determined where we want to go.
    // let do_move_electron check everything
    
    ret = do_move_electron(this, tx, ty, 4);
    
    if (!ret)
    {
	return CYCLE_STOP;
    }

    // check if we crash in to anything in the new room

    // check if we run over anything
    // we do this by blocking the room with a wall of fire / energy /
    // whatever else you like. this wall pushes everything out of
    // the room, causing damage. also set an Event to remove the wall
    // after a fixed amount of time.
    

    // create a wall Object and put it in the room we came from
    Scyclewall *scw = new_actor<Scyclewall>(Electron::fid());
    storage->lowlevel_add(scw);
    lattice->add(scw, ox, oy);
    scw->set_hmd(100, 0, get_d());            // copy cycle damage to wall
    
    // send the Object to the clients
    create_client_electron(scw, &global_send_queue);
    
    // explode the wall, and make it disappear in some time
    scw->explode(pl);
    // add Event to make it disappear in 5 seconds
    evl->add_event(new_remove_event(scw, 1), 500);
    
    return CYCLE_CONTINUE;
}

int Slightcycle::move_dir(int dir, Electron *pl)
{
    int spent = 0;

    if (get_broken())
    {
	error_message = "Your lightcycle is broken.";
	return 0;
    }
    
    if (dir < DIR_N || dir > DIR_W)
    {
	warning("Slightcycle::move_dir: invalid direction %d", dir);
	return 0;
    }

    // this doesn't really do anything (sets the facing var)
    // but for administrational purposes it should be called
    // because a lightcycle turns automagically.
    // if you want the client to make it turn
    // explicitly, call turn_vehicle instead
    spent += turn(dir);
    
    warning("Slightcycle::move_dir: moving %d rooms in direction %d",
	    int_vars[THROTTLE], dir);

    for (int step = 0; step < int_vars[THROTTLE]; step++)
    {
	// move a step, and see if we can continue after that.
	if (move_step(dir, pl) != CYCLE_CONTINUE)
	{
	    error_message = "SCraaaaash!";

	    // if we crash wait 20 client ticks (2 server ticks)
	    spent += 20;
	    
            // lightcycle does damage to itself
	    rec_damage(get_d(), this);

	    // check if we died
	    if (dead)
	    {
		return spent;
	    }
	    
	    // let the world know what happened
	    write_h(this);

	    return spent;
	}
	else
	{
	    // each step takes 4 timesteps for the client
	    spent += 4;
	}
    }

    if (spent < 10)
	spent = 10;       // minimum time spent = 1 server pulse
    
    return spent;
}

void Slightcycle::die(Electron *killer)
{
    Electron *pl;
    List *l = inv();
    
    // lightcycle's don't disappear if they die, they break.
    //    die_electron(this, killer);
    set_int_var(BROKEN, 1);
    
    // let the player(s) inside know what happened
    if (l)
    {
	l->reset();
	while ((pl = (Electron *)l->get()))
	{
	    if (pl->actor_type == ACTOR_PLAYER)
	    {
		char buf[80];
		sprintf(buf, "Your %s is broken.", type_name);
		message((Splayer *)pl, buf);
	    }
	    
	    l->next();
	}
    }
}

void Slightcycle::set_int_var(int var_id, int val)
{
    if (var_id == THROTTLE)
    {
	set_throttle(val);
    }
    else
	Lightcycle::set_int_var(var_id, val);

    // let the world know what happened
    write_vars(packet_to_queue, &global_send_queue);
}
