/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *          slauncher.cc
 *
 *          class definition of a Slauncher
 */

#include "slauncher.h"
#include "sgrenade.h"
#include "server/message.h"
#include "server/globals.h"
#include "server/fire.h"
#include "server/usercomm.h"

void Slauncher::set(int _actor_id)
{
    Launcher::set(_actor_id);
    reloading = 0;
    reload_time = 500;
    flight_time = 100;
    fire_range = 50.0;
}

void Slauncher::clear()
{
    Launcher::clear();
    reloading = 0;
}

int Slauncher::fire_at(Electron *bokje, Electron *pl)
{
    // behave as if we did fire_to.
    // as a launcher cannot distinguish between several targets
    // in 1 room anyway, we may as well compute the coordinates
    // and fire at the room.

    Atom *target;

    target = bokje->get_atom();
    ASSERT(target);

    return fire_to(target, pl);
}

int Slauncher::fire_to(Atom *a, Electron *pl)
{
    double dist;
    Bullet *sb = 0;
    Atom *my_atom;
    List *i;
    
    warning("Slauncher::fire_to");
    
    // check reloading
    if (get_reloading())
    {
	error_message = "Launcher is still reloading";
	return 0;
    }
    
    // check target range
    my_atom = get_atom();
    dist = distance(a, my_atom);
    if (dist > fire_range)
    {
	error_message = "Target out of range";
	return 0;
    }

    // find a grenade in our inventory
    i = inv();
    if (i)
    {
	sb = (Bullet *)i->get_head();
    }

    if (!sb)
    {
	error_message = "Launcher is empty";
	return 0;
    }
    
    // move grenade
    // use distance to compute flight time
    warning("sending grenade move from [%d,%d] to [%d,%d]",
					 my_atom->x,
					 my_atom->y,
					 a->x,
					 a->y);
	    
    // move the grenade (don't use checks from do_move_electron)
    print_pos(sb);
    lattice->move_electron(sb, a->top_level_object);
    print_pos(sb);
    
    send_queue_packet(new_packet_command(sb,
					 COMMAND_FROM_TO,
					 my_atom->x,
					 my_atom->y,
					 a->x,
					 a->y,
					 flight_time));

    // set explosion Event
    evl->add_event(new_explode_event(sb, pl), flight_time);
    
    // set reload Event
    set_reloading(1);
    evl->add_event(new_reload_event(this), reload_time);
    
    return 0;
}

