/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *        slaserbeam.cc
 *
 *        server version of Laserbeam
 */

#include "slaserbeam.h"
#include "server/globals.h"

int Slaserbeam::explode(Electron *killer)
{
    Electron *target;
    
    warning("Slaserbeam exploding: %d damage", get_d());

    // find the target
    target = storage->find(int_vars[TARGET_TYPE], int_vars[TARGET_ID]);
    if (!target)
    {
	warning("Slaserbeam::explode : can't find target");
	return 0;
    }
    
    do_damage(target, killer);

    // let the world know what happened (if target still lives)
    if (!target->dead)
    {
	write_h(target);
    }
    
    // get rid of the laserbeam
    destroy_electron(this);
    
    return 1;
}
