/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *        skey.cc
 *
 *        server version of Key
 */

#include "skey.h"
#include "server/message.h"

// a key can fire it's vehicle because it's a weapon
int Skey::fire_to(Atom *a, Electron *pl)
{
    int ret;
    
    if (!v)
    {
	warning("Skey::fire_to : no vehicle to fire");
	return 0;
    }

    if (!v->inv_contains(pl))
    {
	message((Splayer *)pl, "You have to be inside the vehicle to fire.");
	return 0;
    }
    
    ret = v->fire_to(a, pl);
    return ret;
}

// a key can fire it's vehicle because it's a weapon
int Skey::fire_at(Electron *bokje, Electron *pl)
{
    int ret;
    
    if (!v)
    {
	warning("Skey::fire_at : no vehicle to fire");
	return 0;
    }

    if (!v->inv_contains(pl))
    {
	message((Splayer *)pl, "You have to be inside the vehicle to fire.");
	return 0;
    }

    ret = v->fire_at(bokje, pl);
    return ret;
}

// a key can fire it's vehicle because it's a weapon
int Skey::fire_dir(int dir, Electron *pl)
{
    int ret;
    
    if (!v)
    {
	warning("Skey::fire_dir : no vehicle to fire");
	return 0;
    }

    if (!v->inv_contains(pl))
    {
	message((Splayer *)pl, "You have to be inside the vehicle to fire.");
	return 0;
    }

    ret = v->fire_dir(dir, pl);
    return ret;
}
