/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *       shover.h
 *
 *       server version of the Hover
 */

#ifndef _SHOVER_H_
#define _SHOVER_H_

#include "common/atom.h"
#include "common/actors/hover.h"

class Hover_event;

class Shover : public Hover
{
public:
    void set(int actor_id = 0);   // public constructor /destructor
    void clear();

    void die(Electron *pl);
    
    int move_dir(int dir, Electron *pl);
    int get_reloading();
    void set_reloading(int yesno);
    void recharge();
    void cool();
    
    int fire_at(Electron *target, Electron *pl);
    int lay_mine(Electron *pl);

    void set_int_var(int var_id, int val);
    
protected:
    int drive_time;
    int reloading;
    int fire_energy;
    int recharge_time;
    int reload_time;
    int charge_energy;
    float target_range;

    Hover_event *he_recharge;
    Hover_event *he_reload;
};

#endif
