/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *        sgrenade.cc
 *
 *        server version of Grenade
 */

#include "sgrenade.h"
#include "sexplosion.h"
#include "server/globals.h"

int Sgrenade::explode(Electron *killer)
{
    Sexplosion *se;
    int ret;
    
    warning("Sgrenade exploding: %d damage", get_d());

    // make an explosion Object so the client can draw it
    se = new_actor<Sexplosion>(Electron::fid());
    storage->lowlevel_add(se);
    get_atom()->add(se);

    warning("explode_event: created clientside explosion at [%d,%d]",
	    se->gx(), se->gy());
    create_client_electron(se, &global_send_queue);

    // schedule the explosion Object to disappear in a few seconds
    evl->add_event(new_remove_event(se, 1), 200);

    ret = damage_all_in_parent(this, killer);

    // get rid of the grenade
    destroy_electron(this);
    
    return ret;
}
