/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *        sdoor.cc
 *
 *        server implementation of Door
 */

#include "sdoor.h"
#include "splayer.h"
#include "server/message.h"
#include "server/globals.h"
#include "server/usercomm.h"

void Sdoor::set(int _actor_id)
{
    Door::set(_actor_id);
    open_time = 200;
}

void Sdoor::clear()
{
    Door::clear();
}

int Sdoor::open(Splayer *pl)
{
    switch (get_state())
    {
	case LOCKED:
	    message(pl, "The door is locked.");
	    break;
	case OPEN:
	    message(pl, "The door is already open.");
	    break;
	case OPENING:
	    message(pl, "The door is opening.");
	    break;
	case CLOSING:
	    message(pl, "The door is closing.");
	    break;
	case CLOSED:
	    message(pl, "Ok.");

	    set_state(OPENING);

	    // open in 2 seconds
	    evl->add_event(new_door_event(get_atom(), OPEN), open_time);
	    
	    return 1;
	    break;
	default:
	    fatal("Sdoor::open : invalid state %d", get_state());
	    break;
    }

    return 0;
}

int Sdoor::close(Splayer *pl)
{
    switch (get_state())
    {
	case LOCKED:
	    message(pl, "The door is locked.");
	    break;
	case OPEN:

	    // push everything out of the room
	    if (!push_all())
	    {
		message(pl, "The door is stuck.");
		break;
	    }
	    
	    message(pl, "Ok.");
	    set_state(CLOSING);
	    
	    // close in 2 seconds
	    evl->add_event(new_door_event(get_atom(), CLOSED), open_time);

	    return 1;
	    break;
	case OPENING:
	    message(pl, "The door is opening.");
	    break;
	case CLOSING:
	    message(pl, "The door is closing.");
	    break;
	case CLOSED:
	    message(pl, "The door is already closed.");
	    break;
	default:
	    fatal("Sdoor::open : invalid state %d", get_state());
	    break;
    }

    return 0;
}

int Sdoor::lock(Splayer *pl)
{
    switch (get_state())
    {
	case LOCKED:
	    message(pl, "The door is already locked.");
	    break;
	case OPEN:
	    message(pl, "The door is open.");
	    break;
	case OPENING:
	    message(pl, "The door is opening.");
	    break;
	case CLOSING:
	    message(pl, "The door is closing.");
	    break;
	case CLOSED:
	    // check if player owns the key to the door
	    if (owns_key(pl))
	    {    
		message(pl, "Ok.");
		set_state(LOCKED);
		return 1;
	    }
	    else
	    {
		message(pl, "You don't have the key.");
	    }
    	    break;
	default:
	    fatal("Sdoor::open : invalid state %d", get_state());
	    break;
    }

    return 0;
}

int Sdoor::unlock(Splayer *pl)
{
    switch (get_state())
    {
	case LOCKED:
	    // check if player owns a key
	    if (owns_key(pl))
	    {
		message(pl, "Ok.");
		set_state(CLOSED);
		return 1;
	    }
	    else
	    {
		message(pl, "You don't have the key.");
	    }
	    break;
	case OPEN:
	    message(pl, "The door is open.");
	    break;
	case OPENING:
	    message(pl, "The door is opening.");
	    break;
	case CLOSING:
	    message(pl, "The door is closing.");
	    break;
	case CLOSED:
	    message(pl, "The door is not locked.");
    	    break;
	default:
	    fatal("Sdoor::open : invalid state %d", get_state());
	    break;
    }

    return 0;
}

int Sdoor::push_all()
{
    Electron *e;
    List scratch_list;
    
    if (!inv())
	return 1;

    inv()->clearcopy(&scratch_list);
    
    for (scratch_list.reset();
	 (e = (Electron *)scratch_list.get());
	 scratch_list.next())
    {
	warning("sdoor::push_all : pushing %s", e->type_name);

	if (!random_push(e))
	{
	    warning("pushing %s (%d) failed, door can't close.",
		    e->type_name, e->actor_id);
	    return 0;
	}
    }

    return 1;
}
