/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *         scyclewall.cc
 *
 *         class definition of a Scyclewall
 */

#include "scyclewall.h"
#include "server/globals.h"
#include "server/usercomm.h"

void Scyclewall::explode(Electron *pl)
{
    List scratch_list;
    Atom *a;
    Electron *e;
    
    // throw everything out of the room we are in
    // do damage to all objects thrown out

    warning("Scyclewall::explode [%d,%d]", gx(), gy());

    a = get_atom();
    
    if (!a)
    {
	// we're not in a valid room, don't bother
	warning("Scyclewall::explode : not in a valid room [%d, %d]",
		gx(), gy());
    }
    else
    {
	// for now do damage only on players
	// use the scratch List because it is possible that the player
	// is removed from the List by the explode: this will mess up
	// the List and screw up the loop order.
	a->get(LIST_PLAYER)->clearcopy(&scratch_list);
	
	for (scratch_list.reset();
	     (e = (Electron *)scratch_list.get());
	     scratch_list.next())
	{
	    // only push players that are at the same inventory level
	    // (don't push players out of tanks)
	    if (e->parent != parent)
		continue;

	    warning("Scyclewall::explode : damaging player %d", e->actor_id);
	    do_damage(e, pl);

	    // check if it died
	    if (e->dead)
		continue;
	    
	    // let the world know who was damaged
	    write_h(e);
	    
	    // to do : throw them out of the room
	    random_push(e);
	}
    }
}
