/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *        sblue_ball.cc
 *
 *        server version of Blue_ball
 */

#include "sblue_ball.h"
#include "sexplosion.h"
#include "server/globals.h"

void Sblue_ball::set(int _actor_id = 0)
{
    Blue_ball::set(_actor_id);
    range = 3; // explode radius around the center
}

void Sblue_ball::clear()
{
    Blue_ball::clear();
}

int Sblue_ball::explode(Electron *killer)
{
    int
	x = 0,
	y = 0,
	mx = gx(),
	my = gy();
    
    Sexplosion *se;
    Atom *a;
    
    warning("Sblue_ball exploding: %d damage", get_d());
    warning("explode_event: creating massive clientside explosion at [%d,%d]",
	    gx(), gy());

    for (x = -range; x <= range; x++)
    {
	for (y = -range; y <= range; y++)
	{
	    // check the radius (try to make a cirle)
	    if (x * x + y * y > range * range)
	    {
		// out of circle range
		continue;
	    }
	    
            // use lattice->get to check out of bound rooms
	    a = lattice->get(x + mx, y + my);
	    if (a)
	    {
		// make an explosion Object so the client can draw it
		se = new_actor<Sexplosion>(Electron::fid());
		storage->lowlevel_add(se);
		a->add(se);
		
		create_client_electron(se, &global_send_queue);
		
		// schedule the explosion Object to disappear in a few seconds
		evl->add_event(new_remove_event(se, 1), 100);
		damage_all_in_room(a, this, killer);
	    }
	}
    }

    return 1;
}
