/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *          sammo_pad.cc
 */


#include "sammo_pad.h"
#include "server/globals.h"

void Sammo_pad::set(int _actor_id)
{
    Ammo_pad::set(_actor_id);
    Spad::set();
}

void Sammo_pad::clear()
{
    Ammo_pad::clear();
    Spad::clear();
}

int Sammo_pad::trigger(Electron *who)
{
    if (int_vars[RELOADING])
    {
	return 0;
    }

    if (reload_electron(who))
    {
	reload();
	set_int_var(RELOADING, 1);

	return 1;
    }

    return 0;
}

int Sammo_pad::reload_electron(Electron *what)
{
    switch(what->actor_type)
    {
	case ACTOR_LAUNCHER:
	    return reload_launcher((Slauncher *)what);
	    break;
    
	case ACTOR_TANK:
	    return reload_tank((Stank *)what);
	    break;

        case ACTOR_HOVER:
	    return reload_hover((Shover *)what);
	    break;

	default:
	    break;
    }
    
    return 0;
}

int Sammo_pad::reload_tank(Stank *t)
{
    TRACE("Sammo_pad : reloading tank");

    // check if the tank has to be reloaded
    if (t->get_int_var(Tank::AMMO) >= t->max_ammo())
	return 0;
    
    // reload it
    t->set_int_var(Tank::AMMO,
		   min(t->max_ammo(), t->get_int_var(Tank::AMMO) + 5));
    
    return 1;
}

int Sammo_pad::reload_hover(Shover *h)
{
    TRACE("Sammo_pad : reloading hover");

    // check if the hover needs to be reloaded
    if (h->get_int_var(Shover::BATTERY) >= 1000)
	return 0;
    
    // reload it
    h->set_int_var(Shover::BATTERY, 1000);
    
    return 1;
}

int Sammo_pad::reload_launcher(Slauncher *l)
{
    List *i = l->inv();
    Electron *e;
    int ball_type;
    
    TRACE("Sammo_pad : reloading launcher");

    // check if the launcher needs to be reloaded
    if (i)
    {
	int balls = 0;
	
	// check if there are balls in the launcher
        for (i->reset(); (e = (Electron *)i->get()); i->next())
	{
	    if (e->actor_type == ACTOR_BLUE_BALL
		||
		e->actor_type == ACTOR_RED_BALL
		||
		e->actor_type == ACTOR_YELLOW_BALL)
	    {
		balls++;
	    }
	}

	if (balls >= 3)
	    return 0;
    }

    // create a new ball (random color)
    ball_type = (int) (3.0 * rand() / (RAND_MAX + 1.0));
    switch(ball_type)
    {
	case 0:
	    e = new_actor<Sblue_ball>(Electron::fid());
	    break;
	case 1:
	    e = new_actor<Syellow_ball>(Electron::fid());
	    break;
	case 2:
	    e = new_actor<Sred_ball>(Electron::fid());
	    break;
	default:
	    fatal("Sammo_pad::reload_launcher: invalid ball type %d",
                  ball_type);
	    // shut the compiler up. *stomp*
	    e = 0;
	    break;
    }

    // put the ball in the launcher
    storage->lowlevel_add(e);
    l->get_atom()->add(e, l);

    // create the ball on the clientside
    create_client_electron(e, &global_send_queue);
    // let the client launcher pick up the ball
    send_queue_packet(new_packet_command(l, COMMAND_PICKUP, e, 0));
    
    return 1;
}

void Sammo_pad::set_int_var(int var_id, int val)
{
    Ammo_pad::set_int_var(var_id, val);

    write_vars(packet_to_queue, &global_send_queue);
}
