/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *          repairvfunc.h
 *
 *          class definition of Rvfunc
 *          Rvfunc is a server-baseclass for all derivatives
 *          of Repair_vehicle. It contains all functionality
 *          of Repair_vehicle, which is not allowed in the common library.
 */

#ifndef _RVFUNC_H_
#define _RVFUNC_H_

#include "common/actors/repairv.h"
#include "server/events/repair_ev.h"
#include "common/srchrout.h"

// Repair_vehicle is a virtual baseclass because it is included
// twice: once in this class, and once via the normal route:
// sdoctor->doctor->repair_vehicle
// sdoctor->rvfunc->repair_vehicle

class Rvfunc : virtual public Repair_vehicle
{
public:
    Rvfunc();

    void set();
    void clear();
    
    void set_event(Repair_event *_re);
    void clear_event();
    
    void pulse();
    void fold();
    void unfold();
    int  move();
    void find_target();
    
protected:
    List *route;
    Routeplanner *rp;
    Repair_event *re;
    int pulse_time;
};

#endif
