/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *   plug.h
 *
 *   class definition of the plug
 */

#ifndef _PLUG_H_
#define _PLUG_H_

#include "common/object.h"
#include <netinet/in.h>

class Plug : public Object
{
public:
    Plug(char const *adress = "localhost", int n_port = 5000);
    Plug(int _file_des, char const *_hostname, int _port, sockaddr_in _address);
    ~Plug();

    int open();
    int close();

    int read(char *buffer, int bytes);
    int write(char const *buffer, int bytes);

    // sets up the plug as a listen plug
    int start_listening();
    Plug *check_new_connection();

    int get_port() const;
    char const *get_adress() const;

    int is_open();

    int get_rw_totals(int *read_bytes, int *write_bites);
    
private:
    int init_sockaddr(const char *hostname, int port);
    int can_write(int usec) const;
    int can_read(int usec) const;
	
    int file_des, port;
    char *hostname;
    sockaddr_in address;
    int listening, opened;

    int total_read_bytes;
    int total_write_bytes;
};

#endif
