/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *   fusebox.h
 *
 *   class definition of the fusebox
 */

#ifndef _FUSEBOX_H_
#define _FUSEBOX_H_

#include "common/object.h"
#include "plug.h"

class Fusebox : public Object
{
public:
    Fusebox();
    ~Fusebox();

    int init(int nr_sockets = 4, int port = 5000);
    
    int check_new_connection();
    int close_connection(int plug_index);

    Plug *operator[](int plug_index);

    int get_nr_plugs() const;
    
private:
    Plug **plugs;
    Plug *listen_plug;
    int nr_plugs;
};

extern int fusebox_abort;

#endif
