/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *   fusebox.cc
 *
 *   class implementation of the fusebox
 */

#include "common/utils.h"
#include "fusebox.h"

Fusebox::Fusebox()
{
    nr_plugs = 0;
    plugs = 0;
    listen_plug = 0;
}

Fusebox::~Fusebox()
{
    for (int i = 0; i < nr_plugs; i++)
    {
	if (plugs[i])
	{
	    close_connection(i);
	}
    }

    delete listen_plug;
    delete [] plugs;
}


int Fusebox::init(int nr_s, int port)
{
    int ret;
    
    nr_plugs = nr_s;
    plugs = new (Plug *)[nr_plugs];
    for (int i = 0; i < nr_plugs; i++)
    {
	plugs[i] = 0;
    }

    listen_plug = new Plug("0.0.0.0", port);
    ret = listen_plug->start_listening();

    // 0 = ok, -1 = failure
    if (ret < 0)
    {
	warning("Fusebox: could not make the socket listen to reason, exiting");
    }

    return ret;
}


int Fusebox::check_new_connection()
{
    Plug *np = listen_plug->check_new_connection();

    if (!np)
    {
	return -1;
    }
    else
    {
	for (int i = 0; i < nr_plugs; i++)
	{
	    if (!plugs[i])
	    {
		// found an empty slot: make a new plug
		plugs[i] = np;
		warning("Fusebox: new Plug in outlet %d", i);

		return i;
	    }
	}
    }

    // everything full ? (this should be handled by the game, always
    // keep one free plug slot for new connections)
    warning("Fusebox::check_new_connection() : BUG! no free plug slot");
    delete np;
    
    return -1;
}


int Fusebox::close_connection(int plug_index)
{
    if (!plugs[plug_index])
	return 0;
    
//    plugs[plug_index]->close();
    delete plugs[plug_index];
    plugs[plug_index] = 0;

    return 1;
}

Plug *Fusebox::operator[](int plug_index)
{
    if (plug_index < 0 || plug_index >= nr_plugs)
	return 0;

    return plugs[plug_index];
}

int Fusebox::get_nr_plugs() const
{
    return nr_plugs;
}
