#include "client/renderer/renderer.h"
#include "mainloop.h"
#include "mapedit.h"
#include "client/dirty.h"
#include "dialog.h"
#include "dirty.h"


// checks if an electron should be deleted
static int maped_should_be_deleted(Object *o)
{
   Electron *e = (Electron *)o;

   if ((e->actor_type != ACTOR_SYSTEM) && e->gx() == -1 && e->gy() == -1)
      return List::FILTER_MOVE;

   return List::FILTER_LEAVE;

}
// dumps all objects in an atom with postion -1,-1
// into a garbagelist and shreds that
static void maped_garbage_collect(Atom *a)
{


   for (int i=0;i<LIST_LAST;i++)
   {
      a->get(i)->filter(maped_should_be_deleted, garbagelist);
   }

   delete_objects(garbagelist);

}


static void maped_keepup_logic()
{
    unsigned time_elapsed;

    time_elapsed = tickcount;
    tickcount = 0;

    if (time_elapsed >  100)
    {
        time_elapsed = 100;
    }

    while(time_elapsed--)
    {
       renderer->advance_logic();
    
       
    }

}

void mainloop()
{
    
    playing = TRUE;
    gtime = tickcount = gtime10 = 0;


    camheight = 20;
    renderer->cons_set_smooth_scroll(TRUE);
    renderer->set_map_height(50, 55);

    renderer->render_mode(Renderer::RENDER_MODE_MAPEDIT);
    renderer->cursor(0,0);

    mapedit_dialog_init();

    while (playing)
    {
//        message("TOP LOOP %d", gtime);


        
        if (lattice)
        {
            maped_flush_dirtylist();
            
//            clear(playfield);
            renderer->cursor(cursor_x,cursor_y);
            if (blok_exists)
               renderer->block(blok_min_x, blok_min_y,blok_max_x, blok_max_y);
            else
               renderer->block(-1,-1,-1,-1);
               
            renderer->render(camheight, NULL,  cursor_x, cursor_y);
        }

        // the renderer has dealt with all deleted objects,
        // so now filter them from the storage atom and delete them
        if (collect_garbage)
           maped_garbage_collect(storage);

        mapedit_dialog_render();

        renderer->overlay_bitmap(mapedit_dialog_bitmap);

        renderer->draw_frame();

        maped_keepup_logic();
    }
    mapedit_dialog_exit();
    
    renderer->set_map_height(199, 199);
    renderer->cons_set_smooth_scroll(FALSE);
}
