#include "mapedit.h"
#include "init.h"
#include "client/init.h" // the mapeditor basically *is* the client, with a different main and mainloop function
#include "mainloop.h"
#include "client/clutils.h"
#include "load.h"
#include "client/renderer/renderer.h"
#include "server/parser/parser.h"




int main(int argc, char **argv)
{
      // init client lib
      init(argc, argv, TRUE);

      // initialise the mapedit specific stuff
      mapedit_init();


      //for parser(contains type names)
      init_map_actor_types();

      load_map(mapeditor_mapname);

      if (lattice)
         renderer->start(lattice->get_w(), lattice->get_h());
         
      mainloop();

      if (lattice)
         renderer->stop();


      save_map("testsave.map");
         
      shutdown_map_actor_types();
      
      mapedit_shutdown();
      // shutdown client lib
      shutdown();

      return 0;
}
END_OF_MAIN();


