#include "mapedit.h"
#include "server/parser/parser.h"
#include "server/parser/tools.h"
#include "load.h"
#include "dirty.h"
#include "common/act_type.h"

void load_map(char *name)
{

      ifstream *infile = new ifstream(name);

      if (!(*infile))
          fatal("could not open file");

      Parser *p = new Parser(infile);

      if (!(p->yyparse()))
      {
          warning("error parsing mapfile");
          delete lattice;
          storage->delete_objects();
          lattice = NULL;
      }
      delete p;
      delete infile;


      List *l;
      Electron *e;

      for (int i=0;i<LIST_LAST;i++)
      {
         l = storage->get(i);


         l->reset();

         while((e = (Electron *)l->get()))
         {
            if (e->actor_type != ACTOR_SYSTEM)
                maped_add_to_dirtylist(e, FALSE);

            l->next();
         }
      }
      
}


static int atom_count = 0;
static int tag_count = 0;
static int for_count = 0;
static int electron_count = 0;
static int histogram[ACTOR_LAST];


static void indent(FILE *out, int indent)
{
   for (int i=0;i<indent;i++)
       fprintf(out, "\t");
}

static void save_electron(FILE *out, Electron *e)
{
   static int ind = 0;
   int needs_tag = 0;
   List *inv = e->inv();
   Electron *child;
   Electron *target = NULL;

   electron_count++;

   histogram[e->actor_type]++;

   if (e->is_group(GROUP_VEHICLE) || e->actor_type == ACTOR_DOOR)
      needs_tag = true;

   if (e->actor_type == ACTOR_KEY)
       target = ((Key *)e)->get_vehicle();

   if (e->actor_type == ACTOR_DOORKEY)
       target = ((Doorkey *)e)->get_door();


   ind++;

   if (inv || needs_tag || target)
   {
      indent(out, ind);
      fprintf(out, "%s\n", map_actor_types[e->actor_type]);
      indent(out, ind);
      fprintf(out, "{\n");
      if (needs_tag)
      {
         indent(out, ind+1);
         fprintf(out, "tag %s_%d\n",map_actor_types[e->actor_type], e->actor_id);
         tag_count++;
      }

      if (target)
      {
         indent(out, ind+1);
         fprintf(out, "for %s_%d\n",map_actor_types[target->actor_type], target->actor_id);
         for_count++;
      }

      if (inv)
      {
         inv->reset();
         while ((child = (Electron *)(inv->get())))
         {
            save_electron(out, child);
            inv->next();
         }
      }

      indent(out, ind);
      fprintf(out, "}\n");
   }
   else
   {
      indent(out, ind);
      fprintf(out, "%s;\n", map_actor_types[e->actor_type]);
   }


   ind--;
}

static void save_atom(FILE *out, Atom *a)
{
   if (!a->top_level_object)
   {
      warning("skipping empty atom at %d, %d",a->x, a->y);
      return;
   }

   fprintf(out,"< %d, %d> \n{\n", a->x, a->y);

   atom_count++;

   save_electron(out, a->top_level_object);

   fprintf(out,"} //\tend of atom <%d, %d>\n\n", a->x, a->y);
   
}

void save_map(char *filename)
{
   FILE *out = fopen(filename, "w");
   int sx,sy, vx,vy;

   Atom *a;

   lattice->get_reset(&sx, &sy);
   lattice->get_vote(&vx, &vy);

   if (!out)
      fatal("could not write to file %s", filename);



   tag_count = atom_count = for_count = electron_count = 0;
   for (int i=0;i<ACTOR_LAST;i++)
       histogram[i] = 0;



   fprintf(out, "// Mapfile for electron, generated by the mapeditor \n");
   fprintf(out, "SIZE <%d, %d>  \t // size of the map\n\n", lattice->get_w(), lattice->get_h());
   fprintf(out, "Name \"%s\"    \t // name of the map\n\n", sys->get_string_var(System::MAP_NAME));
   fprintf(out, "START <%d , %d>\t // startpoint\n\n",sx, sy);
   fprintf(out, "VOTE <%d , %d>\t // votepoint\n\n",vx, vy);

   fprintf(out, "//atoms follow \n");

   for (int i=0;i< lattice->get_w();i++)
   {
      for (int j=0;j< lattice->get_h();j++)
      {
         a = lattice->get(i,j);

         if (a)
            save_atom(out, a);
      }
   }

   fprintf(out, "/* statics:\n"
                " *  atoms: %d\n"
                " *  tags: %d\n"
                " *  fors: %d\n"
                " *  electrons: %d\n", atom_count, tag_count,for_count,electron_count);
                
   for (int i = 0;i< ACTOR_LAST;i++)
   {
      fprintf(out, " *    %s: %d\n",map_actor_types[i], histogram[i]);
   }

   fprintf(out," */\n");
   
   fprintf(out,"\n\n// EOF\n");
   
   fclose(out);

}
