#include "keys.h"
#include "mapedit.h"
#include "digout.h"



void maped_process_key(int key)
{

   int a,s;
   int moved = FALSE;
   int ox = cursor_x, oy = cursor_y;

   a = (key & 0xFF);
   s = key >> 8;



   switch(s)
   {
      default:
       break;
      case KEY_ESC:
       playing = FALSE;
       break;
      case KEY_H:
       blok_exists = FALSE;
       break;
      case KEY_UP:
       cursor_y--;
       cursor_y = MAX(0, cursor_y);
       break;
      case KEY_DOWN:
       cursor_y++;
       cursor_y = MIN(lattice->get_h() - 1, cursor_y);
       break;
      case KEY_LEFT:
       cursor_x--;
       cursor_x = MAX(0, cursor_x);
       break;
      case KEY_RIGHT:
       cursor_x++;
       cursor_x = MIN(lattice->get_w() - 1, cursor_x);
       break;

   }

   if (cursor_x != ox || cursor_y != oy)
       moved = TRUE;

   if ((edit_mode & EDITMODE_SELECT) || key_shifts & KB_SHIFT_FLAG)
   {
      if (!blok_exists)
      {
         blok_min_x = blok_max_x = ox;
         blok_min_y = blok_max_y = oy;
         blok_exists = TRUE;
      }

      if (moved)
      {
         blok_max_x = MAX(blok_max_x, cursor_x);
         blok_max_y = MAX(blok_max_y, cursor_y);
         blok_min_x = MIN(blok_min_x, cursor_x);
         blok_min_y = MIN(blok_min_y, cursor_y);
      }
      
   }

   if (edit_mode &= EDITMODE_DIGOUT)
      digout();


}

