/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
#include "dirty.h"
#include "../client/renderer/renderer.h"
#include "../client/extradat.h"


static List *dirty_list = NULL;

void maped_init_dirtylist()
{
   dirty_list = new List;
   #ifdef LISTDEBUG
     dirty_list->double_push_allowed = -1;
   #endif
   
}

void maped_shutdown_dirtylist()
{
   delete dirty_list;
}

void maped_flush_dirtylist()
{
   renderer->is_dirty(dirty_list);
}

// add to or delete from renderer map
void maped_add_to_dirtylist(Electron *e, int remove = FALSE)
{
   Display_data *d = (Display_data *)e->extra_data;;

   if (!d)
   {
      d = new Display_data(e);
      e->extra_data = d;
   }


      
   Atom *a = e->get_atom();
   if (!a)
   {
//      severe("add_to_dirtylist: %d (%s) has no atom",e->actor_id, e->type_name);
      a = storage; // if it has just been taken out it has no valid atom: take storage
   }


   if (remove)
       d->event_go_from_to(e->gx(),e->gy(), -1,-1,0);
   else
       d->event_go_from_to(-1,-1,e->gx(),e->gy(),0);

   dirty_list->push(e);
   // notify the Object of the change in state
   e->change_state();
   
}
