#include "dialog.h"
#include "keys.h"
#include "digout.h"


BITMAP *real_screen;

static MENU file_menu[] =
{
 {"&Load", NULL,NULL,D_DISABLED,NULL},
 {"&Save", NULL,NULL,D_DISABLED,NULL},
 {"&Exit", NULL,NULL,D_DISABLED,NULL},
 {NULL, NULL,NULL,0,NULL}
};

static MENU edit_menu[] =
{
 {"&Copy", NULL, NULL,D_DISABLED,NULL},
 {"Cu&t", NULL,NULL,D_DISABLED,NULL},
 {"&Paste", NULL,NULL,D_DISABLED,NULL},
 {NULL, NULL,NULL,0,NULL}
};

static MENU help_menu[] =
{
 {"Help", NULL, NULL,D_DISABLED,NULL},
 {"Hilfe", NULL,NULL,D_DISABLED,NULL},
 {"M'aide", NULL,NULL,D_DISABLED,NULL},
 {"Helperdehelphelphelp", NULL,NULL,D_DISABLED,NULL},
 {"help dus", NULL,NULL,D_DISABLED,NULL},
 {NULL, NULL,NULL,0,NULL}
};



#define MODE_DIGOUT  0
#define MODE_EDIT 1
#define MODE ROOMTYPE 2

static int mode_menu_edit_cb();
static int mode_menu_digout_cb();
static int mode_menu_roomtype_cb();

static MENU mode_menu[] =
{
 {" &Digout", mode_menu_digout_cb,NULL,0,NULL},
 {" &Edit", mode_menu_edit_cb, NULL,D_SELECTED,NULL},
 {" &Room type", mode_menu_roomtype_cb, NULL, 0, NULL },
 {NULL, NULL,NULL,0,NULL}
};


#define MAIN_FILE 0
#define MAIN_EDIT 1
#define MAIN_MODE 2
#define MAIN_HELP 3

static MENU main_menu[] =
{
 {"&File", NULL, file_menu,0,NULL},
 {"&Edit", NULL, edit_menu,0,NULL},
 {"&Mode",NULL, mode_menu, 0,NULL},
 {"&Help", NULL, help_menu,0,NULL},
 {NULL, NULL,NULL,0,NULL}
};

static void mode_menu_cb(int which)
{
   if (which == MODE_EDIT)
   {
      mode_menu[MODE_EDIT].flags |= D_SELECTED;
      mode_menu[MODE_DIGOUT].flags &= ~D_SELECTED;
      main_menu[MAIN_EDIT].flags &= ~D_DISABLED;
      edit_mode &= ~EDITMODE_DIGOUT;
   }
   else
   {
      mode_menu[MODE_EDIT].flags &= ~D_SELECTED;
      mode_menu[MODE_DIGOUT].flags |= D_SELECTED;
      main_menu[MAIN_EDIT].flags |= D_DISABLED;
      edit_mode |= EDITMODE_DIGOUT;
      digout();
   }
}

static int mode_menu_edit_cb()
{
   mode_menu_cb(MODE_EDIT);
   return D_REDRAW;
}

static int mode_menu_digout_cb()
{
   mode_menu_cb(MODE_DIGOUT);
   return D_REDRAW;
}




int d_mymenu_proc(int msg, DIALOG *d, int c)
{
   int ret = D_O_K;
   BITMAP *res = screen;
   if (msg == MSG_CLICK || msg == MSG_CHAR || msg == MSG_XCHAR || msg == MSG_KEY)
   {
      screen = real_screen;
      ret = d_menu_proc(msg,d,c);
      screen = res;
   }
   else if (msg == MSG_DRAW)
   {
      ret = d_menu_proc(msg,d,c);
   }
   return ret;
}


int d_leftoverkeys_proc(int msg, DIALOG *d, int c)
{
   if (msg == MSG_XCHAR)
   {
      maped_process_key(c);

      return D_USED_CHAR;
   }

   return D_O_K;
}

static DIALOG mapedit_dlg[] =
{
   /* (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)  (d1)    (d2)  (dp)              (dp2) (dp3) */
   { d_mymenu_proc,        0,    0,    300, 20,  255,  0,    0,    0,       0,        0,    main_menu,             NULL, NULL  },
   { d_leftoverkeys_proc,  0,    0,    0, 0,  255,  0,    0,    0,       0,        0,    NULL,             NULL, NULL  },
   { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,        0,    NULL,             NULL, NULL  }
};


//--------------------------------------------------
//dialog to pick current roomtype


// returns actor id of room nr 'index'
static int room_id(int index)
{
   int count = 0;
   
   for (int i=1;i<ACTOR_LAST;i++)
   {
      if (global_actor_statics[i]->is_group(GROUP_ROOM))
      {
         if (count == index)
            return i;
         count++;
      }
   }

   ASSERT(FALSE);

   return 0;

}

static const char *roomlist_callback(int index, int *listsize)
{
   int count = 0;


   if (index < 0)
   {
      for (int i=1;i<ACTOR_LAST;i++)
      {
         if (global_actor_statics[i]->is_group(GROUP_ROOM))
         {
            count++;
         }
      }

      *listsize = count;
      return NULL;
   }


   return global_actor_statics[room_id(index)]->type_name;


}


#define ROOMTYPE_DLG_LIST 1

static DIALOG roomtype_dlg[] =
{
   /* (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)  (d1)    (d2)  (dp)      (dp2) (dp3) */
   { d_box_proc,        0,    0,    300, 200,  255,  0,    0,    0,       0,        0,    NULL,   NULL, NULL  },
   { d_list_proc,      10,   10,    280, 180,  255,  0,    0,    D_EXIT,  0,        0,    (void *)roomlist_callback,   NULL, NULL  },
   { NULL,              0,    0,    0,    0,    0,    0,    0,    0,      0,        0,    NULL,   NULL, NULL  }
};



static int mode_menu_roomtype_cb()
{

   centre_dialog(roomtype_dlg);
   set_dialog_color(roomtype_dlg, makecol(0,0,0), makecol(200, 255, 255));

   popup_dialog(roomtype_dlg, -1);


   cur_roomtype = room_id(roomtype_dlg[ROOMTYPE_DLG_LIST].d1);


   return 0;

}








BITMAP *mapedit_dialog_bitmap;


static DIALOG_PLAYER *dp;




void mapedit_dialog_init()
{
   clear_to_color(mapedit_dialog_bitmap, bitmap_mask_color(mapedit_dialog_bitmap));


   gui_fg_color = makecol(30,20,0);
   gui_bg_color = makecol(250,250,255);
   gui_mg_color = makecol(128,128,140);

//   centre_dialog(mapedit_dlg);

   dp = init_dialog(mapedit_dlg, -1);

//   show_mouse(mapedit_dialog_bitmap);
}



void mapedit_dialog_render()
{
   real_screen = screen;

   screen = mapedit_dialog_bitmap;
   if (!update_dialog(dp))
       playing = FALSE;
   screen = real_screen;

}

void mapedit_dialog_exit()
{
   show_mouse(NULL);
   shutdown_dialog(dp);
   
}



