#include <stdlib.h>
#include <stdio.h>

void pe(char *s)
{
   printf(s);
   exit(1);
}

int main(int argc, char **argv)
{
   char buf[1024];
   
   if (argc<3)
      pe("usage : asc2map <infile> <outfile>");

   FILE *in = fopen(argv[1],"r");
   FILE *out = fopen(argv[2],"w");

   if (!in || !out)
      pe("error opening one of the files");

   if(!fgets(buf,1024,in))
       pe("error reading map height");

   int map_height = atoi(buf);

   if (!map_height)
   {
      pe("invalid map height");
   }

   if(!fgets(buf,1024,in))
       pe("error reading map width");

   int map_width = atoi(buf);

   if (!map_width)
   {
      pe("invalid map width");
   }

   fprintf(out,"SIZE <%d, %d>\n", map_width, map_height);
   fprintf(out,"NAME \"%s from asc2map\"\n", argv[2]);


   for (int i=0;i< map_height;i++)
   {
      if(!fgets(buf,1024,in))
      {
         printf("not enough lines (eof at line %d, expected %d) ( map should be ok, though too small)\n", i+2, map_height+1);
         exit(1);
      }

      for (int j=0;j<(int)strlen(buf);j++)
      {
         if (j > map_width - 1)
         {
            printf("line too long at line %d,%d, clipping\n",i,j);
            continue;
         }
         
         switch(buf[j])
         {
            case 's':
             // fall through
            case 'S':
              fprintf(out,"START <%d, %d>\n", j, i);
             // fall through
            case 'r':
             // fall through
            case 'R':
              fprintf(out,"<%d, %d> { simple_room;} \n", j, i);
             break;
            default:
             break;
         }
      }
      
   }
   return 0;
}
