#
#  Configuration file for the Allegro library.
#
#  If you leave a parameter blank, Allegro will autodetect (ie. guess :-)
#
#  This file should be kept either in the same directory as your program,
#  or in a location pointed to by the "ALLEGRO" environment variable.
#
#  On Unix, this file may also be stored as ~/.allegrorc or /etc/allegrorc.



# Unix system drivers:
#
#  XWIN     - XWindows
#  LNXC     - Linux console

system = 



# DOS graphics drivers:
#
#  VGA      - Standard VGA
#  MODX     - Mode-X
#  VBE1     - VESA 1.x
#  VB2B     - VBE 2.0 (banked)
#  VB2L     - VBE 2.0 (linear)
#  VBE3     - VBE 3.0
#  VBAF     - VBE/AF
#  XTND     - Xtended mode
#
# Windows graphics drivers:
#
#  DXAC     - DirectX with hardware acceleration
#  DXSO     - DirectX without hardware acceleration
#  DXSA     - DirectX in safe-mode, with all the fancy features disabled
#  DXWN     - DirectX in windowed mode
#  DXOV     - DirectX overlay (fast windowed mode, only works on some cards)
#  GDIB     - GDI mode (slow windowed mode, works on all cards)
#
# Linux console graphics drivers:
#
#  FB       - fbcon device
#  VBAF     - VBE/AF
#  SVGA     - SVGAlib
#  VGA      - Standard VGA
#  MODX     - Mode-X
#
# X graphics drivers:
#
#  XWIN     - standard X Windows
#  XDGA     - XFree86 Direct Graphics Access 1.0 (DGA)
#  XDFS     - Fullscreen DGA 1.0 mode
#  DGA2     - DGA 2.0 mode
#  DGAS     - DGA 2.0 software only mode
#
# BeOS graphics drivers:
#
#  BFS      - Fullscreen
#  BFSS     - Fullscreen safe
#  BWN      - Windowed
#
# You can also specify different drivers for a particular mode or color
# depth, eg. "gfx_card_640x480x16 = VBE3", "gfx_card_24bpp = VBE1", or
# you can provide a number of alternative drivers, for example
# "gfx_card1 = VGA", "gfx_card2 = MODX", etc.

gfx_card1 = XWIN
gfx_card2 = FB



# DOS and Linux: where to look for the VBE/AF driver
vbeaf_driver = 



# Linux only: fbcon device file (see below for fbcon timing data)
framebuffer = 



# Keyboard mapping file (this can be a .cfg file on disk, or an object from
# keyboard.dat). Currently available layouts are:
#
#  BE       - Belgium
#  BR       - Brazil
#  CH       - Swiss
#  CZ       - Czech
#  DE       - Germany
#  DK       - Denmark
#  DVORAK   - Dvorak
#  ES       - Spain
#  FI       - Finland
#  FR       - France
#  IT       - Italy
#  NO       - Norway
#  PT       - Portugal
#  RU       - Russian
#  SE       - Sweden
#  SK       - Slovak
#  UK       - United Kingdom
#  US       - United States

keyboard = 



# Language translation file (this can be a .cfg file on disk, or an 
# object from language.dat). Currently available translations are:
#
#  BR       - Portuguese (Brazil)
#  CZ       - Czech
#  DE       - German
#  DK       - Danish
#  EN       - English
#  ES       - Spanish
#  FI       - Finnish
#  FR       - French
#  IT       - Italian
#  NO       - Norwegian
#  RU       - Russian
#  SE       - Svenska
#  SK       - Slovak

language = 



# DOS mouse drivers:
#
#  MICK     - mickey mode driver (normally the best)
#  I33      - int 0x33 callback driver
#  POLL     - timer polling (for use under NT)
#
# Linux console mouse drivers:
#
#  LPS2     - PS2 mouse
#  LIPS     - PS2 mouse with Intellimouse extension
#  MS       - Microsoft serial mouse
#  IMS      - Microsoft serial mouse with Intellimouse extension
#  GPMD     - GPM repeater data (Mouse Systems protocol)

mouse = MS



# Whether to emulate the third mouse button (yes or no)
emulate_three = 



# Linux only: name of the mouse device file (eg. /dev/mouse)
mouse_device = /dev/mouse



# Linux/fbcon mode timings. Duplicate then fill in `X', `Y' and
# the timings themselves. You can copy them from fb.modes directly -- the
# first two figures on the geometry line are X and Y here, and the figures
# on the timings line are the first fields here (up to `vsync_len')

[fb_mode_XxY]
pixclock = 
left_margin = 
right_margin = 
upper_margin = 
lower_margin = 
hsync_len = 
vsync_len = 
vmode = 
sync = 


[sound]



# DOS digital sound drivers:
#
#  0        - none
#  SB       - Sound Blaster (autodetect breed)
#  SB10     - Sound Blaster 1.0
#  SB15     - Sound Blaster 1.5
#  SB20     - Sound Blaster 2.0
#  SBP      - Sound Blaster Pro
#  SB16     - Sound Blaster 16
#  ESS      - ESS AudioDrive
#  ESC      - Ensoniq Soundscape
#  WSS      - Windows Sound System
#
# Windows digital sound drivers:
#
#  0        - none
#  DXA      - first DirectSound device
#  DXB      - second DirectSound device
#  ...      - etc
#  AXA      - first DirectSound device using Allegro mixer
#  AXB      - second DirectSound device using Allegro mixer
#  ...      - etc
#  WOA      - high quality WaveOut device
#  WOB      - low quality WaveOut device
#
# Unix digital sound drivers:
#
#  0        - none
#  OSSD     - Open Sound System
#  ESDD     - Enlightened Sound Daemon
#  ALSA     - ALSA Sound System
#
# BeOS digital sound drivers:
#
#  0        - none
#  BDIG     - BeOS digital sound system
#
digi_card = OSSD



# DOS music drivers:
#
#  0        - none
#  OPL      - Adlib (autodetect OPL version)
#  OPL2     - OPL2 FM synth
#  OPLX     - Dual OPL2 (SB Pro-1)
#  OPL3     - OPL3 FM synth
#  SB       - raw SB MIDI interface
#  MPU      - MPU-401 MIDI interface
#  DIGI     - DIGMID software wavetable
#  AWE      - AWE32
#
# Windows music drivers:
#
#  0        - none
#  W32M     - win32 MIDI mapper
#  W32A     - first win32 MIDI device
#  W32B     - second win32 MIDI device
#  ...      - etc
#  DIGI     - DIGMID software wavetable
#
# Linux music drivers:
#
#  0        - none
#  OSSM     - Open Sound System
#  DIGI     - DIGMID software wavetable
#  AMID     - ALSA Sound System
#
# BeOS music drivers:
#
#  0        - none
#  BMID     - BeOS MIDI synthetizer
#  DIGI     - DIGMID software wavetable
# 
midi_card = 0



# sound input drivers (same format as above, can usually be left blank)
digi_input_card = 
midi_input_card = 



# how many voices to reserve for each driver
digi_voices = -1
midi_voices = -1



# how loud? (range 0-255)
digi_volume = -1
midi_volume = -1



# sample mixing quality (0=fastest, 1=full 16 bit precision, 2=interpolation)
quality = 2



# toggling this between 0 and 1 reverses the left/right panning of samples
flip_pan = 0



# DOS and Unix: sample output frequency (eg. 44100)
sound_freq = 45176



# Unix only: preferred number of bits (8 or 16)
sound_bits = 16



# Unix only: stereo output (1 or 0)
sound_stereo = 1



# DOS only: soundcard port address (usually 220)
sound_port = -1



# DOS only: soundcard DMA channel (usually 1)
sound_dma = -1



# DOS only: soundcard IRQ number (usually 7)
sound_irq = -1



# DOS only: FM synth port address (usually 388)
fm_port = 



# DOS only: MPU-401 port address (usually 330)
mpu_port = 



# DOS only: MPU-401 IRQ number (usually the same as sound_irq)
mpu_irq = 



# DOS only: instrument definitions for the Adlib driver
ibk_file = 
ibk_drum_file = 



# Unix only: OSS device driver name (usually /dev/dsp or /dev/audio)
oss_driver = /dev/dsp



# Unix only: number of OSS driver fragments (buffers) and size of each buffer
oss_numfrags = 2
oss_fragsize = 512



# Unix only: OSS MIDI device name (usually /dev/sequencer)
oss_midi_driver = /dev/sequencer



# Unix only: OSS mixer device name (usually /dev/mixer)
oss_mixer_driver = 



# Unix only: name of the Enlightened Sound Daemon server
esd_server = 



# Unix only: card number and PCM device for the ALSA driver
alsa_card = 
alsa_pcmdevice = 



# Unix only: size of ALSA driver fragments (buffers)
alsa_numfrags = 



# BeOS only: MIDI synthetizer instruments quality (0=low, 1=high)
be_midi_quality = 



# BeOS only: MIDI sample mixing frequency in Hz (11025, 22050 or 44100)
be_midi_freq = 



# BeOS only: MIDI interpolation (0=none, 1=fast linear, 2=linear)
be_midi_interpolation = 



# BeOS only: MIDI reverberation intensity (0 to 5)
be_midi_reverb = 



# patch set for the DIGMID software wavetable driver
patches = 



[joystick]
joytype = 



# BeOS only: joystick device port name (as reported on system joystick prefs)
joystick_device = 



[preferences]
resolution = 640
colordepth = 16
scaled_res = 0
lighting_method = 0
console_transparancy = 0
speedblur = 1
nausea_level = 1
filter = 1

[hosts]
number_of_hosts = 6
hostname0 = localhost
port0 = 5000
hostname1 = phoenix.icce.rug.nl
port1 = 5000
hostname2 = hoefnix
port2 = 5000
last_used = 2
hostname3 = getafix:0.0
port3 = 5000
hostname4 = getafix
port4 = 5000
hostname5 = oosix.icce.rug.nl
port5 = 5000

[aliases]
num_aliases = 15
alias000 = get
get = pickup %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
alias001 = out
out = exit %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
alias002 = mine
lay = do_command 12 %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
mine = do_command 12 %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
alias003 = fire
fire = do_command 11 %0 %1
alias004 = open
open = do_command 13 %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
alias005 = close
close = do_command 14 %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
alias006 = lock
lock = do_command 16 %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
alias007 = unlock
unlock = do_command 15 %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
alias008 = l
sa = fire ambulance 40 %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
l = look %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
alias009 = temp
temp = get_numvar 79 5 %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
alias010 = batt
batt = get_numvar 79 4 %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
alias011 = tn
tn = get_numvar 137 %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
alias012 = stg
stg = start_tag_game %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
alias013 = sttg
sttg = start_twoteam_game %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
alias014 = vote
vote = do_command 17 %0 0 0 0 0

[keybindings]
nr_keybindings = 14
key0 = 15131
shifts0 = 0
cmd0 = QUIT
key1 = 12032
shifts1 = 0
cmd1 = enter vehicle
key2 = 12288
shifts2 = 0
cmd2 = exit
key3 = 12544
shifts3 = 0
cmd3 = pickup key
key4 = 12800
shifts4 = 0
cmd4 = drop key
key5 = 23580
shifts5 = 0
cmd5 = screenshot
key6 = 13056
shifts6 = 0
cmd6 = zoom out
key7 = 13312
shifts7 = 0
cmd7 = zoom in
key8 = 13568
shifts8 = 0
cmd8 = fps
key9 = 13824
shifts9 = 0
cmd9 = dump_list_stats
key10 = 14080
shifts10 = 0
cmd10 = shutdown_server
key11 = 14336
shifts11 = 0
cmd11 = font
key12 = 2816
shifts12 = 6
cmd12 = hoi
key13 = 14592
shifts13 = 0
cmd13 = bla

